#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "a.h"
#include "Parser.h"
#include "ParserIO.h"


class IOC : public ParserIO
{
public:
	int read_text(char *s,int *l) {
		int i;

		*l = read(0, s, *l);
		if (*l > -1)
			s[*l] = 0;
		while (strlen(s) && (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10))
			s[strlen(s) - 1] = 0;
		for (i = 0; i < (int)strlen(s); i++)
			if (s[i] >= 'a' && s[i] <= 'z')
				s[i] -= 32;
		return *l;
	}
	int write_text(char *s,int l) {
		s[l] = 0;
		printf("%s",s);
		fflush(stdout);
		return 0;
	}
};


int main(int argc,char *argv[])
{
	Parser cmdline;
	struct stat st;
	IOC ioc;
	int loop;
	int i;
	char slask[200];
	char *s;

	if (argc > 1)
	{
		cmdline.SetParserIO(&ioc);
		for (loop = 1; loop < argc; loop++)
		{
			s = strstr(argv[loop],"/");
			if (s)
			{
				*s = 0;
				chdir(argv[loop]);
				stat(s + 1,&st);
			}
			else
			{
				stat(argv[loop],&st);
			}
			i = 0;
			if (st.st_mode & 0100)
				i |= 1;
			if (st.st_mode & 010)
				i |= 2;
			if (st.st_mode & 01)
				i |= 4;
// bits 0 .. 7 = tiabsrab
			if ("TIABSRAB"[i] == 'A')
			{
				sprintf(slask,"LOAD %s",s ? s + 1 : argv[loop]);
				cmdline.cmd( slask );
				strcpy(slask,"LIST");
				cmdline.cmd( slask );
			}
			if (s)
			{
				chdir("..");
			}
		}
	} else
	{
		printf("Usage: %s <A file> [-source]\n", *argv);
	}
	return 0;
}

